xquery version "1.0-ml";

(: setup-database initializes range indexes in the MBB database.
 :
 : Run it once after you've setup your application server.
 :
 : @author Norman Walsh, norman.walsh@marklogic.com
 : @date 28 Aug 2009
 :)

import module namespace admin = "http://marklogic.com/xdmp/admin" 
       at "/MarkLogic/admin.xqy";

declare option xdmp:mapping "false"; 

declare variable $ns := "http://www.marklogic.com/ns/nwalsh/twitter/tweets";

declare variable $dbid := xdmp:database();

declare function local:er-index($config as element(configuration),
                                $ns as xs:string,
                                $name as xs:string,
                                $type as xs:string) 
        as element(configuration)
{
  let $rangespec
    :=  admin:database-range-element-index(
              $type, $ns, $name,
	      "http://marklogic.com/collation/", fn:false() )
  return
    admin:database-add-range-element-index($config, $dbid, $rangespec)
};

let $config := admin:get-configuration()

let $c01 := local:er-index($config, $ns, "text", "string")
let $c02 := local:er-index($c01, $ns, "service", "string")
let $c03 := local:er-index($c02, $ns, "name", "string")
let $c04 := local:er-index($c03, $ns, "user_name", "string")
let $c05 := local:er-index($c04, $ns, "screen_name", "string")
let $c06 := local:er-index($c05, $ns, "login", "string")
let $c07 := local:er-index($c06, $ns, "mention", "string")
let $c08 := local:er-index($c07, $ns, "group", "string")
let $c09 := local:er-index($c08, $ns, "tag", "string")
let $c10 := local:er-index($c09, $ns, "host", "string")
let $c11 := local:er-index($c10, $ns, "favorited", "string")
let $c12 := local:er-index($c11, $ns, "id", "decimal")
let $c13 := local:er-index($c12, $ns, "userid", "decimal")
let $c14 := local:er-index($c13, $ns, "in_reply_to_status_id", "decimal")

let $c15 := local:er-index($c14, $ns, "created_at", "dateTime")

return
  (admin:save-configuration($c15),
  "Database configured")
