xquery version "1.0-ml";

(: setup-accounts initializes the Twitter/Identi.ca accounts for MBB.
 :
 : Typically, you run it once after you've setup your application server.
 : If you want to add accounts later, you can run it again. Removing accounts
 : from this configuration will not delete any status messages downloaded
 : previously.
 :
 : @author Norman Walsh, norman.walsh@marklogic.com
 : @date 28 Aug 2009
 :)

declare default function namespace "http://www.w3.org/2005/xpath-functions";

declare namespace t="http://www.marklogic.com/ns/nwalsh/twitter/tweets";

declare option xdmp:mapping "false"; 

declare variable $acctcoll :=  "http://www.marklogic.com/collections/accounts";

declare variable $EBADSERVICE as xs:QName := xs:QName("t:EBADSERVICE");
declare variable $EBADLOGIN as xs:QName := xs:QName("t:EBADLOGIN");

(: $config holds the configuration.
 :
 : Sample configurations are shown for Twitter and Identi.ca. You can
 : add any service that supports the Twitter API.
 :
 : Change SCREEN_NAME and PASSWORD below as appropriate.
 :
 : t:service   is a short name for the service.
 : t:api-uri   is the base URI for Twitter API requests.
 : t:homepage  is the homepage of the service.
 : t:at-link   is the prefix that should be used to link to users home pages,
 :             http://twitter.com/ndw, for example.
 : t:hash-link is the prefix that should be used to link to hash tag pages,
 :             http://twitter.com/#search?q=%23docbook, for example.
 : t:notice-link is the pattern that should be used to link directly to a
 :             particular status message. In this link (and only this link),
 :             %s is replaced by the screen_name of the user who issued the
 :             status and %i is replaced by the ID of the status.
 :             http://twitter.com/ndw/status/3560679323, for example
 : t:login     contains the credentials for a particular login on the service.
 :             You can repeate t:login as many times as you'd like.
 :)
let $config as element(t:configuration) :=
  <t:configuration>
    <t:service>
      <t:service>twitter</t:service>
      <t:api-uri>http://twitter.com</t:api-uri>
      <t:homepage>http://twitter.com</t:homepage>
      <t:at-link>http://twitter.com/</t:at-link>
      <t:hash-link>http://twitter.com/#search?q=%23</t:hash-link>
      <t:notice-link>http://twitter.com/%s/status/%i</t:notice-link>
      <t:login>
	<t:screen_name>SCREEN_NAME</t:screen_name>
	<t:password>PASSWORD</t:password>
      </t:login>
      {(:
      <t:login>
	<t:screen_name>OTHER_SCREEN_NAME</t:screen_name>
	<t:password>OTHER_PASSWORD</t:password>
      </t:login>
      :)}
    </t:service>

    {(:
    <t:service>
      <t:service>identica</t:service>
      <t:api-uri>http://identi.ca/api</t:api-uri>
      <t:homepage>http://identi.ca</t:homepage>
      <t:at-link>http://identi.ca/</t:at-link>
      <t:hash-link>http://identi.ca/tag/</t:hash-link>
      <t:bang-link>http://identi.ca/group/</t:bang-link>
      <t:notice-link>http://identi.ca/notice/%i</t:notice-link>
      <t:login>
	<t:screen_name>SCREEEN_NAME</t:screen_name>
	<t:password>PASSWORD</t:password>
      </t:login>
    </t:service>
    :)}
  </t:configuration>

let $scheck
  := if (count(distinct-values($config/t:service/t:service))
         != count($config/t:service))
     then
       error($EBADSERVICE, "Invalid service configuration")
     else
       ()

let $lcheck
  := for $service in $config/t:service
     return
       if (count(distinct-values($service/t:login/t:screen_name))
           != count($service/t:login))
       then
         error($EBADLOGIN, "Invalid login configuration")
       else
         ()
return
  <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
      <title>Accounts initialized</title>
    </head>
    <body>
      { for $service in $config/t:service
        return
	  for $login in $service/t:login
	  let $account
	    := <t:account>
	         { $service/*[not(self::t:login)] }
		 { $login/* }
	       </t:account>
	  let $uri := concat("/account/", $service/t:service,
	                     "/", $login/t:screen_name)
	  return
	    xdmp:document-insert($uri, $account, (), ($acctcoll))
      }

      <h1>Accounts initialized</h1>

      <ul>
	{ for $service in $config/t:service
	  return
	    for $login in $service/t:login
	    return
	      <li>
		<a href="{$service/t:homepage}/{$login/t:screen_name}">
		  { string($login/t:screen_name) }
		</a>
		on
		<a href="{$service/t:homepage}">
		  { string($service/t:service) }
		</a>
	      </li>
	}
      </ul>
    </body>
  </html>
