xquery version "1.0-ml";

(: post-tweets allows XML Calabash to upload tweets.
 :
 : This isn't actually used by MBB, but is provided in case you already have
 : an XML archive of your status messages.
 :
 : Make sure you change SERVICE and SCREEN_NAME below appropriately before
 : you upload your tweets.
 :
 : @author Norman Walsh, norman.walsh@marklogic.com
 : @date 28 Aug 2009
 :)

import module namespace twitproc="http://www.marklogic.com/ns/nwalsh/twitter/process"
       at "/modules/twitproc.xqy";

import module namespace acct="http://www.marklogic.com/ns/nwalsh/twitter/accounts"
       at "/modules/accounts.xqy";

declare default function namespace "http://www.w3.org/2005/xpath-functions";

declare namespace t="http://www.marklogic.com/ns/nwalsh/twitter/tweets";

declare option xdmp:mapping "false"; 

declare variable $tweets external;

declare variable $account as element(t:account)
        := acct:get-login("SERVICE", "SCREEN_NAME");

<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>Loading new tweets...</title>
  </head>
  <body>
    <h1>Loading new tweets...</h1>
    <ul>
      { twitproc:update-statuses($account, xdmp:unquote($tweets)/*, true()) }
    </ul>
  </body>
</html>

