xquery version "1.0-ml";

(: get-tweets downloads all the new tweets for all the configured accounts.
 :
 : @author Norman Walsh, norman.walsh@marklogic.com
 : @date 28 Aug 2009
 :)

import module namespace twit="http://www.marklogic.com/ns/nwalsh/twitter"
       at "/modules/twitter.xqy";

import module namespace twitproc="http://www.marklogic.com/ns/nwalsh/twitter/process"
       at "/modules/twitproc.xqy";

import module namespace acct="http://www.marklogic.com/ns/nwalsh/twitter/accounts"
       at "/modules/accounts.xqy";

declare default function namespace "http://www.w3.org/2005/xpath-functions";

declare namespace t="http://www.marklogic.com/ns/nwalsh/twitter/tweets";

declare option xdmp:mapping "false"; 

<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>Loading new tweets...</title>
  </head>
  <body>
    <h1>Loading new tweets...</h1>

    { (: Could just say "for $account in /t:account", but this approach might
         make it easier to extend to multiple users. Or not. :) }

    { for $service in acct:services()
      return
	<div>
	  <h1>Backing up {$service}</h1>
	  {
	    for $login in acct:logins($service)
	    let $acct := acct:get-login($service, $login)

	    (: Invoke so that we avoid concurrent update exceptions for overlapping
               tweets among accounts that follow the same users. :)
	    let $lis := xdmp:invoke("/modules/get-new-tweets.xqy",
	                            (fn:QName("","account"), $acct))
	    return
	      <div>
		<h2>Getting tweets for {$login}</h2>
		{ $lis }
	      </div>
	  }
	</div>
    }

  </body>
</html>
