/*
 * NamespaceContextParserTest.java
 *
 * Created on March 20, 2006, 1:22 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.nwalsh.namespace;

import junit.framework.*;
import javax.xml.namespace.NamespaceContext;
import java.util.Iterator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.util.XML11Char;
import java.io.StringReader;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;

/**
 *
 * @author ndw
 */
public class NamespaceContextParserTest extends TestCase {
    StringReader xmlDoc
            = new StringReader ("<doc xmlns='http://example.org/ns/test'><p>my text</p></doc>");
    
    public NamespaceContextParserTest (String testName) {
        super (testName);
    }

    protected void setUp () throws Exception {
    }

    protected void tearDown () throws Exception {
    }

    public static Test suite () {
        TestSuite suite = new TestSuite();
        suite.addTest(new NamespaceContextParserTest("testNSParse"));
        suite.addTest(new NamespaceContextParserTest("testNoNSParse"));
        suite.addTest(new NamespaceContextParserTest("testNSParseDefaultNS"));
        return suite;
    }

 public void testNSParse () {
        System.out.println("NSParse");
        
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware (true);
        dbf.setValidating(false);
        
        try {
            DocumentBuilder db = dbf.newDocumentBuilder ();
            Document doc = db.parse (new InputSource (xmlDoc));
            
            NamespaceContextHelper nch
                    = new NamespaceContextHelper ("t", "http://example.org/ns/test");
        
            XPath xpath = XPathFactory.newInstance ().newXPath ();
            xpath.setNamespaceContext (nch);
        
            String text = xpath.evaluate ("//t:p", doc);
        
            assertEquals (text, "my text");
        } catch (SAXException se) {
            fail("Unexpected SAX Exception: " + se.toString ());
        } catch (IOException ioe) {
            fail("Unexpected IO Exception: " + ioe.toString ());
        } catch (ParserConfigurationException pce) {
            fail ("Unexpected Parser Configuration Exception: " + pce.toString());
        } catch (XPathExpressionException xee) {
            fail ("Unexpected XPath Expression Exception: " + xee.toString ());
        }        
 }

  public void testNoNSParse () {
        System.out.println("NoNSParse");
        
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware (false);
        dbf.setValidating(false);
        
        try {
            DocumentBuilder db = dbf.newDocumentBuilder ();
            Document doc = db.parse (new InputSource (xmlDoc));
            
            NamespaceContextHelper nch
                    = new NamespaceContextHelper ("t", "http://example.org/ns/test");
        
            XPath xpath = XPathFactory.newInstance ().newXPath ();
            xpath.setNamespaceContext (nch);
        
            Object p = xpath.evaluate ("//t:p", doc, XPathConstants.NODE);
        
            assertNull("XPath must not find node when parsed without namespaces", p);
        } catch (SAXException se) {
            fail("Unexpected SAX Exception: " + se.toString ());
        } catch (IOException ioe) {
            fail("Unexpected IO Exception: " + ioe.toString ());
        } catch (ParserConfigurationException pce) {
            fail ("Unexpected Parser Configuration Exception: " + pce.toString());
        } catch (XPathExpressionException xee) {
            fail ("Unexpected XPath Expression Exception: " + xee.toString ());
        }        
 }

  public void testNSParseDefaultNS () {
        System.out.println("NSParseDefaultNS");
        
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware (true);
        dbf.setValidating(false);
        
        try {
            DocumentBuilder db = dbf.newDocumentBuilder ();
            Document doc = db.parse (new InputSource (xmlDoc));
            
            NamespaceContextHelper nch
                    = new NamespaceContextHelper ("", "http://example.org/ns/test");
        
            XPath xpath = XPathFactory.newInstance ().newXPath ();
            xpath.setNamespaceContext (nch);
        
            Object p = xpath.evaluate ("//p", doc, XPathConstants.NODE);
        
            assertNull ("NCNames must never match a namespace", p);
        } catch (SAXException se) {
            fail("Unexpected SAX Exception: " + se.toString ());
        } catch (IOException ioe) {
            fail("Unexpected IO Exception: " + ioe.toString ());
        } catch (ParserConfigurationException pce) {
            fail ("Unexpected Parser Configuration Exception: " + pce.toString());
        } catch (XPathExpressionException xee) {
            fail ("Unexpected XPath Expression Exception: " + xee.toString ());
        }        
 }

}
   