/*
 * NamespaceContextHelperTest.java
 * JUnit based test
 *
 * Created on March 17, 2006, 1:10 PM
 */

package com.nwalsh.namespace;

import junit.framework.*;
import javax.xml.namespace.NamespaceContext;
import java.util.Iterator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.util.XML11Char;

/**
 *
 * @author ndw
 */
public class NamespaceContextHelperTest extends TestCase {
    
    public NamespaceContextHelperTest (String testName) {
        super (testName);
    }

    protected void setUp () throws Exception {
    }

    protected void tearDown () throws Exception {
    }

    public static Test suite () {
        TestSuite suite = new TestSuite(NamespaceContextHelperTest.class);
        
        return suite;
    }

    /**
     * Test of add method, of class com.nwalsh.namespace.NamespaceContextHelper.
     */
    public void testAdd () {
        System.out.println("add");
        
        String prefix = "t";
        String prefix2 = "t2";
        String uri = "http://example.org/ns/test";
        String uri2 = "http://example.org/ns/test2";
        
        NamespaceContextHelper instance = new NamespaceContextHelper();

        try {
            instance.add(null, uri);
            fail ("Did not catch null prefix");
        } catch(NullPointerException npe) {
            // nop
        }
        
        try {
            instance.add(prefix, null);
            fail ("Did not catch null URI");
        } catch(NullPointerException npe) {
            // nop
        }
        
        instance.add(prefix, uri);
        instance.add(prefix, uri);  // this is ok
        instance.add(prefix2, uri); // so is this
        
        try {
            instance.add(prefix, uri2);
            fail ("Did not catch attempt to rebind prefix");
        } catch(IllegalArgumentException iae) {
            // nop
        }
        
        try {
            instance.add("xml", "http://someuri");
            fail ("Did not catch attempt to bind bogus URI to 'xml'");
        } catch(IllegalArgumentException iae) {
            // nop
        }
        
        try {
            instance.add("bogusprefix", "http://www.w3.org/XML/1998/namespace");
            fail ("Did not catch attempt to bind XML namespace to bogus prefix'");
        } catch(IllegalArgumentException iae) {
            // nop
        }
        
        try {
            instance.add("xmlns", "http://someuri");
            fail ("Did not catch attempt to bind bogus URI to 'xmlns'");
        } catch(IllegalArgumentException iae) {
            // nop
        }
        
        try {
            instance.add("bogusprefix", "http://www.w3.org/2000/xmlns");
            fail ("Did not catch attempt to bind 'xmlns' namespace to bogus prefix'");
        } catch(IllegalArgumentException iae) {
            // nop
        }
        
        try {
            instance.add("xmlns", "http://www.w3.org/2000/xmlns");
            fail ("Did not catch attempt to bind 'xmlns' to the putatively correct URI");
        } catch(IllegalArgumentException iae) {
            // nop
        }

        try {
            instance.add("p:", uri);
            fail ("Did not catch non-NCName prefix");
        } catch(IllegalArgumentException iae) {
            // nop
        }

        try {
            instance.add("p q", uri);
            fail ("Did not catch non-NCName prefix");
        } catch(IllegalArgumentException iae) {
            // nop
        }
        try {
            instance.add("0p", uri);
            fail ("Did not catch non-NCName prefix");
        } catch(IllegalArgumentException iae) {
            // nop
        }
        
    }

    /**
     * Test of getNamespaceURI method, of class com.nwalsh.namespace.NamespaceContextHelper.
     */
    public void testGetNamespaceURI () {
        System.out.println("getNamespaceURI");
        
        String prefix = "t";
        String prefix2 = "t2";
        String uri = "http://example.org/ns/test";
        String uri2 = "http://example.org/ns/test2";

        NamespaceContextHelper instance = new NamespaceContextHelper(prefix,uri);
        instance.add(prefix2,uri2);
        
        String expResult = uri;
        String result = instance.getNamespaceURI(prefix);
        assertEquals(expResult, result);
        
        expResult = uri2;
        result = instance.getNamespaceURI (prefix2);
        assertEquals(expResult, result);
    }

    /**
     * Test of getPrefix method, of class com.nwalsh.namespace.NamespaceContextHelper.
     */
    public void testGetPrefix () {
        System.out.println("getPrefix");
        
        String prefix = "t";
        String prefix2 = "t2";
        String uri = "http://example.org/ns/test";
        String uri2 = "http://example.org/ns/test2";

        NamespaceContextHelper instance = new NamespaceContextHelper(prefix,uri);
        instance.add(prefix2,uri2);
        
        String expResult = prefix;
        String result = instance.getPrefix(uri);
        assertEquals(expResult, result);
        
        expResult = prefix2;
        result = instance.getPrefix(uri2);
        assertEquals(expResult, result);
    }

    /**
     * Test of getPrefixes method, of class com.nwalsh.namespace.NamespaceContextHelper.
     */
    public void testGetPrefixes () {
        System.out.println("getPrefixes");
        
        String prefix = "t";
        String prefix2 = "t2";
        String prefix3 = "t3";
        String uri = "http://example.org/ns/test";
        String uri2 = "http://example.org/ns/test2";
        String uri3 = "http://example.org/ns/test";

        NamespaceContextHelper instance = new NamespaceContextHelper(prefix,uri);
        instance.add(prefix2,uri2);
        instance.add(prefix3,uri3);

        boolean returnedprefix = false;
        boolean returnedprefix2 = false;
        boolean returnedprefix3 = false;
        boolean returnedNothingElse = true;
        Iterator result = instance.getPrefixes();
        while (result.hasNext ()) {
            String pfx = (String) result.next();
            if (pfx.equals(prefix)) {
                returnedprefix = true;
            } else if (pfx.equals (prefix2)) {
                returnedprefix2 = true;
            } else if (pfx.equals (prefix3)) {
                returnedprefix3 = true;
            } else {
                returnedNothingElse = false;
            }
        }
        
        assertTrue(returnedprefix);
        assertTrue(returnedprefix2);
        assertTrue(returnedprefix3);
        assertTrue(returnedNothingElse);
        
        returnedprefix = false;
        returnedprefix3 = false;
        returnedNothingElse = true;
        result = instance.getPrefixes(uri);
        while (result.hasNext ()) {
            String pfx = (String) result.next();
            if (pfx.equals(prefix)) {
                returnedprefix = true;
            } else if (pfx.equals (prefix3)) {
                returnedprefix3 = true;
            } else {
                returnedNothingElse = false;
            }
        }
        
        assertTrue(returnedprefix);
        assertTrue(returnedprefix3);
        assertTrue(returnedNothingElse);
    }

    /**
     * Test of getNamespaceURIs method, of class com.nwalsh.namespace.NamespaceContextHelper.
     */
    public void testGetNamespaceURIs () {
        System.out.println("getNamespaceURIs");
        
        String prefix = "t";
        String prefix2 = "t2";
        String prefix3 = "t3";
        String uri = "http://example.org/ns/test";
        String uri2 = "http://example.org/ns/test2";
        String uri3 = "http://example.org/ns/test";

        NamespaceContextHelper instance = new NamespaceContextHelper(prefix,uri);
        instance.add(prefix2,uri2);
        instance.add(prefix3,uri3);

        boolean returneduri = false;
        boolean returneduri2 = false;
        boolean returnedNothingElse = true;
        Iterator result = instance.getNamespaceURIs();
        while (result.hasNext ()) {
            String ruri = (String) result.next();
            if (ruri.equals(uri)) {
                returneduri = true;
            } else if (ruri.equals (uri2)) {
                returneduri2 = true;
            } else {
                returnedNothingElse = false;
            }
        }
        
        assertTrue(returneduri);
        assertTrue(returneduri2);
        assertTrue(returnedNothingElse);
    }
    
}
