/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.namespace;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.apache.xerces.util.XML11Char;

public class NamespaceContextHelper
implements NamespaceContext {
    private Hashtable<String, String> ns = new Hashtable();

    public NamespaceContextHelper() {
    }

    public NamespaceContextHelper(Hashtable initialNamespaces) {
        Enumeration keys = initialNamespaces.keys();
        while (keys.hasMoreElements()) {
            String prefix = (String)keys.nextElement();
            String uri = (String)initialNamespaces.get(prefix);
            this.add(prefix, uri);
        }
    }

    public NamespaceContextHelper(String prefix, String uri) {
        this.add(prefix, uri);
    }

    public void add(String prefix, String uri) {
        if (prefix == null || uri == null) {
            throw new NullPointerException("Null prefix or uri passed to NamespaceContextHelper");
        }
        if (this.ns.containsKey(prefix)) {
            String curURI = this.ns.get(prefix);
            if (uri.equals(curURI)) {
                return;
            }
            throw new IllegalArgumentException("Attempt to change binding in NamespaceContextHelper");
        }
        if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(uri)) {
            throw new IllegalArgumentException("The prefix 'xml' can only be bound to 'http://www.w3.org/XML/1998/namespace' in NamespaceContextHelper");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri) && !"xml".equals(prefix)) {
            throw new IllegalArgumentException("The namespace 'http://www.w3.org/XML/1998/namespace' can only have the prefix 'xml' in NamespaceContextHelper");
        }
        if ("xmlns".equals(prefix) || "http://www.w3.org/2000/xmlns".equals(uri)) {
            throw new IllegalArgumentException("Neither the prefix 'xmlns' nor the URI 'http://www.w3.org/2000/xmlns' can be bound in NamespaceContextHelper");
        }
        if ("".equals(prefix)) {
            this.ns.put(prefix, uri);
        } else if (XML11Char.isXML11ValidNCName((String)prefix)) {
            this.ns.put(prefix, uri);
        } else {
            throw new IllegalArgumentException("Prefix is not a valid NCName in NamespaceContextHelper");
        }
    }

    public String getNamespaceURI(String prefix) {
        return this.ns.get(prefix);
    }

    public String getPrefix(String namespaceURI) {
        if (this.ns.containsValue(namespaceURI)) {
            Enumeration<String> keys = this.ns.keys();
            while (keys.hasMoreElements()) {
                String pfx = keys.nextElement();
                String uri = this.ns.get(pfx);
                if (!namespaceURI.equals(uri)) continue;
                return pfx;
            }
        }
        return null;
    }

    public Iterator getPrefixes() {
        return this.getPrefixes(null);
    }

    public Iterator getPrefixes(String namespaceURI) {
        return new NSIterator(this.ns, namespaceURI);
    }

    public Iterator getNamespaceURIs() {
        Hashtable<String, String> uriHash = new Hashtable<String, String>();
        Enumeration<String> keys = this.ns.keys();
        while (keys.hasMoreElements()) {
            String pfx = keys.nextElement();
            String uri = this.ns.get(pfx);
            if (uriHash.containsKey(uri)) continue;
            uriHash.put(uri, pfx);
        }
        return new NSIterator(uriHash, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NSIterator
    implements Iterator {
        private Enumeration<String> keys;

        public NSIterator(Hashtable<String, String> hash, String value) {
            this.keys = hash.keys();
            if (value != null) {
                Hashtable<String, String> vHash = new Hashtable<String, String>();
                while (this.keys.hasMoreElements()) {
                    String key = this.keys.nextElement();
                    String val = hash.get(key);
                    if (!val.equals(value)) continue;
                    vHash.put(key, val);
                }
                this.keys = vHash.keys();
            }
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasMoreElements();
        }

        public String next() {
            return this.keys.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove prefix in NamespaceContextHelper");
        }
    }
}

