/*
 * DigestTest.java
 *
 * Created on November 28, 2006, 7:45 PM
 *
 * DigestTest.java is a set of JUnit based tests for Digest.java
 * Copyright (C) 2006 Norman Walsh
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

package com.nwalsh.xslt;

import com.nwalsh.xslt.Digest;

/**
 *
 * @author ndw
 */
public class DigestTest extends junit.framework.TestCase {
    
    public DigestTest(String testName) {
        super(testName);
    }
    
    public void testSHA1() {
        String s = "mailto:ndw@nwalsh.com";
        String sha1 = Digest.sha1(s);
                
        assertEquals(sha1, "9f5c771a25733700b2f96af4f8e6f35c9b0ad327");
    }
    
    public void testMD5() {
        String s = "This is a test string";
        String md5 = Digest.md5(s);
        
        System.out.println("MD5: " + md5);
                
        assertEquals(md5, "c639efc1e98762233743a75e7798dd9c");
    }
}
