/*
 * Digest.java
 *
 * Created on November 28, 2006, 7:36 PM
 *
 * Digest.java provides static methods for computing SHA1 and MD5 hashes.
 * Copyright (C) 2006 Norman Walsh
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * This methods were designed specifically to be called as XSLT extension functions
 * from, for example, Saxon.
 *
 */

package com.nwalsh.xslt;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.math.BigInteger;

/**
 *
 * @author ndw
 */
public class Digest {
    
    /** Creates a new instance of Digest */
    public Digest() {
    }
    
    /**
     * <p>Compute the SHA1 hash of a string.</p>
     *
     * @param string The input string
     *
     * @return The SHA1 hash as a string.
     */
    public static String sha1(String string) {
        String result = "";

        try {
            if (string != null) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(string.getBytes());
                result = new BigInteger(1,md.digest()).toString(16);
            }

            // Hack! Grotesquely inefficient!
            while (result.length() < 40) {
                result = "0" + result;
            }
            
            return result;
        } catch (NoSuchAlgorithmException nsae) {
            return "";
        }
    }
    
    /**
     * <p>Compute the MD5 hash of a string.</p>
     *
     * @param string The input string
     *
     * @return The MD5 hash as a string.
     */
    public static String md5(String string) {
        String result = "";

        try {
            if (string != null) {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(string.getBytes());
                result = new BigInteger(1,md.digest()).toString(16);
            }

            // Hack! Grotesquely inefficient!
            while (result.length() < 32) {
                result = "0" + result;
            }

            return result;
        } catch (NoSuchAlgorithmException nsae) {
            return "";
        }
    }
}
